module RPG
  class Skill
    def initialize
      @id = 0
      @name = ""
      @icon_name = ""
      @description = ""
      @scope = 0
      @occasion = 1
      @animation1_id = 0
      @animation2_id = 0
      @menu_se = RPG::AudioFile.new("", 80)
      @common_event_id = 0
      @sp_cost = 0
      @power = 0
      @atk_f = 0
      @eva_f = 0
      @str_f = 0
      @dex_f = 0
      @agi_f = 0
      @int_f = 100
      @hit = 100
      @pdef_f = 0
      @mdef_f = 100
      @variance = 15
      @element_set = []
      @plus_state_set = []
      @minus_state_set = []
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :icon_name
    attr_accessor :description
    attr_accessor :scope
    attr_accessor :occasion
    attr_accessor :animation1_id
    attr_accessor :animation2_id
    attr_accessor :menu_se
    attr_accessor :common_event_id
    attr_accessor :sp_cost
    attr_accessor :power
    attr_accessor :atk_f
    attr_accessor :eva_f
    attr_accessor :str_f
    attr_accessor :dex_f
    attr_accessor :agi_f
    attr_accessor :int_f
    attr_accessor :hit
    attr_accessor :pdef_f
    attr_accessor :mdef_f
    attr_accessor :variance
    attr_accessor :element_set
    attr_accessor :plus_state_set
    attr_accessor :minus_state_set


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_Skill)
      return my
    end


    def comparer(other)

     
      list_self = [
        @id,
        @name,
        @icon_name,
        @description,
        @scope,
        @occasion,
        @animation1_id,
        @animation2_id,
        @common_event_id,
        @sp_cost,
        @power,
        @atk_f,
        @eva_f,
        @str_f,
        @dex_f,
        @agi_f,
        @int_f,
        @hit,
        @pdef_f,
        @mdef_f,
        @variance,
        @element_set,
        @plus_state_set,
        @minus_state_set
      ]
      
      list_other = [
        other.id,
        other.name,
        other.icon_name,
        other.description,
        other.scope,
        other.occasion,
        other.animation1_id,
        other.animation2_id,
        other.common_event_id,
        other.sp_cost,
        other.power,
        other.atk_f,
        other.eva_f,
        other.str_f,
        other.dex_f,
        other.agi_f,
        other.int_f,
        other.hit,
        other.pdef_f,
        other.mdef_f,
        other.variance,
        other.element_set,
        other.plus_state_set,
        other.minus_state_set
      ]




      if list_self != list_other
        raise(DMKW_DMK_Diff.new("skill.parameters"))
      end

      if @menu_se.comparer(other.menu_se) == false
        raise(DMKW_DMK_Diff.new("skill.menu_se"))
      end



      return true
    end


  end
end
